<?php
/*******************************************************************************
	PHP Random Image Authorization 1.00
	Copyright (c) 2006-2010 uuware.com. All rights reserved.
	Developed by project@uuware.com, Visit http://www.uuware.com/ for details.

	NOTE: This Software and the accompanying materials are copyrighted and 
	contain proprietary information. Unauthorized copying of the Software or 
	accompanying materials even if modified, merged, or included with other 
	software, or of the written materials, is expressly forbidden.

	THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
	EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
	MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
	NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
	LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
	OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
	WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*******************************************************************************/
class StToolAuthcode
{
	var $codeSet = '346789ABCDEFGHJKLMNPQRTUVWXY';// NO:01IO

	function createimg($charlen = 4, $nline = 4, $nnoise = 10, $fontSize = 25, $fontfile = '18thcentury.ttf') {
		if($charlen < 3) {
			$charlen = 3;
		}
		if($fontSize < 20) {
			$fontSize = 20;
		}

		$imageL = $charlen * $fontSize * 1.3 + $fontSize * 0.5;
		$imageH = $fontSize * 1.5;
		$img = imagecreate($imageL, $imageH);
		$bg = imagecolorallocate($img, 243, 251, 254);
		$color = imagecolorallocate($img, mt_rand(1,120), mt_rand(1,120), mt_rand(1,120));

		if($nnoise > 0) {
			$this->writeNoise($img, $imageL, $imageH, $nnoise);
		}
		for($i = 0; $i < $nline; $i++) {
			imageline($img, 0, rand(1, $imageH), $imageL, rand(1, $imageH), $color);
		}

		$ttf = $fontfile;
		if(!is_file($ttf)) {
			$ttf = dirname(__FILE__).DIRECTORY_SEPARATOR.$fontfile;
		}
		if(!is_file($ttf)) {
			die('not exist font file:'.$fontfile);
		}
		$code = '';
		$codeNX = mt_rand($fontSize * 0.5, $fontSize * 1);
		for($i = 0; $i < $charlen; $i++) {
			$code[$i] = $this->codeSet[mt_rand(0, 27)];
			imagettftext($img, $fontSize, mt_rand(-30, 60), $codeNX, $fontSize * 1.1, $color, $ttf, $code[$i]);
			$codeNX += mt_rand($fontSize * 1, $fontSize * 1.3);
		}

		$imgcode = join('', $code);

		header('Cache-Control: no-store, no-cache, must-revalidate');
		header('Cache-Control: post-check=0, pre-check=0', false);
		header('Pragma: no-cache');

		if(function_exists("imagepng")) {
			header("Content-type: image/png");
			imagepng($img);
		}
		else if(function_exists("imagegif")) {
			header("Content-type: image/gif");
			imagegif($img);
		}
		else if(function_exists("imagejpeg")) {
			header("Content-type: image/jpeg");
			imagejpeg($img);
		}
		else {
			die('no imagepng or imagegif');
		}

		imagedestroy($img);
		return $imgcode;
	}

	function writeNoise($img, $imgl, $imgh, $nnoise = 10) {
		for($i = 0; $i < $nnoise; $i++) {
		    $noiseColor = imagecolorallocate(
		                      $img, 
		                      mt_rand(150,225),
		                      mt_rand(150,225),
		                      mt_rand(150,225)
		    );
			for($j = 0; $j < 5; $j++) {
			    imagestring(
			        $img,
			        5, 
			        mt_rand(-10, $imgl),
			        mt_rand(-10, $imgh),
			        $this->codeSet[mt_rand(0, 27)],
			        $noiseColor
			    );
			}
		}
	}
}
function _gets($name, $def = '')
{
	if(isset($_SESSION[$name])) {
		return $_SESSION[$name];
	}
	return $def;
}

if(!isset($_SESSION['ready'])) {
	@session_start();
	$_SESSION['ready'] = true;
}
$charlen = _gets('codelen')!='' ? 0+_gets('codelen') : 4;
$nline = _gets('linecnt')!='' ? 0+_gets('linecnt') : 4;
$nnoise = _gets('noisecnt')!='' ? 0+_gets('noisecnt') : 10;
//if more than max, reset it
if($charlen > 10) {
	$charlen = 10;
}
if($nline > 20) {
	$nline = 20;
}
if($nnoise > 20) {
	$nnoise = 20;
}
$toolAuthcode = new StToolAuthcode();
$code = $toolAuthcode->createimg($charlen, $nline, $nnoise);

//save code to session for next to authorization
$_SESSION['st_authcode'] = $code;
?>
